/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile'
	, 'hbs!applets/wound-care-applet/templates/educationContent'
	, 'hbs!applets/wound-care-applet/templates/empty'],
	function (Portal, Backbone, Marionette, $, _, jqm, template, emptyTemplate) {
		'use strict';
		var that, timer,shouldSubmit, $savePopup;
		return Backbone.Marionette.ItemView.extend({
				className: "applet  scrollable", //scrollable-main
				id: 'wound-care',
				template: template,
				events: {
					'click #save-edu' : 'saveEvent',
					'autosave': "autosaveEvent"
//					,
//					'write-to-note': 'writteToNoteEvent'
				},
				initialize:function(options){
					that = this;
					that.vent = options.vent || new Backbone.Wreqr.EventAggregator();
					that.listenTo(that.vent, 'note-writer-close', that.enableView );
					that.listenTo(that.vent, 'note-writer-open', that.disableView );
					// TODO: Oh my
					if( $("#clinic-event.ui-panel-open").length === 1  )
					{
						that.disableView();
					}
					this.listenTo(this, "write-to-note", that.writteToNoteEvent );
				},
				disableView:function(){
					console.log("disable forms");
					this.template = emptyTemplate;
					this.render();this.onShow();
				},
				enableView:function(){
					console.log("ebable forms");
					this.template = template;
					this.render();this.onShow();
				},
				onShow: function() {
					$('#applet-title h2').html('Educate');
					//this.disableInputs();
					that.$el.trigger('create');
					this.vent.trigger("show");
//					that.$el.attr('style', Portal.scrollableZoneHeight() );
					that.autosavePull();
					that.setupPopup();
				},
				setupPopup: function() {
					$savePopup = $('<div data-role="popup" id="edu-saved" data-inline="true" data-overlay-theme="a" class="wc-popup"><a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" class="ui-btn-right">Close popup</a><p class="wc-subtitle">Education Saved</p></div>');
					$savePopup.on('popupafteropen',function() {
						$savePopup.find('[data-icon="delete"]').focus();
					});
					$savePopup.on('popupafterclose',function() {
						$savePopup.remove();
						that.setupPopup();
					});
				},
				autosaveEvent:function(){
					shouldSubmit = false;
					that.save();
				},
				onClose: function() {
					$savePopup.off('popupafteropen');
					$savePopup.off('popupafterclose');
				},
				writteToNoteEvent:function(){
					if (this.model.get('education').status === 'WRITTEN_TO_NOTE') {
						that.$el.find("input[type='radio'], input[type='checkbox']").checkboxradio('disable');
						that.$el.find('textarea').textinput('disable');
						that.$el.find('button').button("disable");
						that.$el.find("input[type=number]").slider('disable');
					}
				},
				disableInputs: function (){
					if (this.model.get('education').status === 'WRITTEN_TO_NOTE') {
						this.$el.find('input').prop('disabled',true);
						this.$el.find('textarea').prop('disabled',true);
						this.$el.find('button').prop('disabled',true);
					}
				},
				savePopup: function() {
					that.$el.append($savePopup);
					$savePopup.trigger('create');
					$savePopup.popup();
					$savePopup.popup('open');
				},
				saveEvent: function(e){
					this.savePopup();
					shouldSubmit = true;
					this.save();
				},
				save: function() {
					var tempAssessment = this.model.get('education');
					var comment = that.$el.find('#edu-comment').val();
					if (comment !== undefined  && comment !== '')
						tempAssessment.comment = comment;
					var inp = that.$el.find('input:checked');
					_.each(inp,function(i) {

						var $i = $(i);
						if ($i.val()!=='') {
							var name = $i.attr('name'),
								pat = name.indexOf('caregiver') === -1, val;
							name = name.substring(0,name.indexOf('-'));
							if (pat) {
								val = tempAssessment[name].patient.value;
								if(val !== $i.val() && $i.val() !== ''){
									tempAssessment[name].patient.value = $i.val();
									tempAssessment[name].patient.datetime = null;
								}
							}
							else if(!pat) {
								val = tempAssessment[name].caregiver.value;
								if(val !== $i.val() && $i.val() !== ''){
									tempAssessment[name].caregiver.value = $i.val();
									tempAssessment[name].caregiver.datetime = null;
								}
							}
							else
								console.log('save error');
						}

					});
					_.each($('input[data-type="range"]'), function(i){
						var $i = $(i);
						if ($i.val()!=='') {
							var name = $i.attr('name'),
								pat = name.indexOf('caregiver') === -1, val, newVal;
							name = name.substring(0,name.indexOf('-'));
							newVal = parseInt($i.val());
							if (pat) {
								val = tempAssessment[name].patient.value;

								if(val !== newVal) {
									tempAssessment[name].patient.value = newVal;
									tempAssessment[name].patient.datetime = null;
								}
							}
							else if(!pat) {
								val = tempAssessment[name].caregiver.value;
								if(val !== newVal){
									tempAssessment[name].caregiver.value = newVal;
									tempAssessment[name].caregiver.datetime = null;
								}
							}
							else
								console.log('save error');
						}
					});
					if (shouldSubmit) {
						tempAssessment.status = "UPDATED";
						that.status='UPDATED';
					}
					else
						tempAssessment.status = "ACTIVE";
					this.model.set({
						education:tempAssessment
					});
					this.model.save({},{
						success: function() {
							console.log('saved');
						},
						fail: function() {
							console.log('failure to save');
						},
						error: function() {
							console.log('error saving');
						}
					});
				},

				autosavePull:function(){
					var si = this.model.get("education");
					_.each(that.formData().items, function(prop){
						if (!si[prop.id])
							return;
						var cval = si[prop.id].caregiver?si[prop.id].caregiver.value:'',
							pval = si[prop.id].patient?si[prop.id].patient.value:'';
						if (cval && cval !== ''){
							if (cval ==='No' || cval === 'Yes')
								that.$el.find("input[name='"+prop.id+"-caregiver'][value='"+cval+"']").prop("checked",true).checkboxradio("refresh");
							else
								that.$el.find("input[name='"+prop.id+"-caregiver']").val(cval).slider('refresh');
						}
						if (pval && pval !== '') {
							if (pval ==='No' || pval === 'Yes')
								that.$el.find("input[name='"+prop.id+"-patient'][value='"+pval+"']").prop("checked",true).checkboxradio("refresh");
							else
								that.$el.find("input[name='"+prop.id+"-patient']").val(pval).slider('refresh');
						}

						that.$el.find('#edu-comment').val(si.comment);
					});
				},
				formDataSaved: function(){
					var inData = this.model.get('education');
					var outData = this.formData();
					_.each(outData.items, function(el){
						if (inData[el.id].caregiver) {
							outData.items[el.id].caregiver = inData[el.id].caregiver;
							outData.items[el.id].caregiver.yes = "Yes" === inData[el.id].caregiver.value;
							outData.items[el.id].caregiver.no = "No" === inData[el.id].caregiver.value;
						}
						if (inData[el.id].patient){
							outData.items[el.id].patient = inData[el.id].patient;
							outData.items[el.id].patient.yes = "Yes" === inData[el.id].patient.value;
							outData.items[el.id].patient.no = "No" === inData[el.id].patient.value;
						}
					});
					return outData;
				},
				formData: function() {
					var ret = {
						'items': {
							'desireToLearn' : {
								desc:'Evaluated desire to learn:',
								id:'desireToLearn',
								numbers:true
							},
							'abilityToComprehend' : {
								desc:'Evaluated ability to comprehend:',
								id:'abilityToComprehend',
								prev:'10/2',
								numbers:true
							},
							'pressureUlcer' : {
								desc:'Defined a pressure ulcer?',
								id:'pressureUlcer',
								numbers:false
							},
							'riskFactors' : {
								desc:'Explained risk factors?',
								id:'riskFactors',
								numbers:false
							},
							'routineSkinInspection' : {
								desc:'Explained a routine skin inspection?',
								id:'routineSkinInspection',
								numbers:false
							},
							'importanceOfNutritionEtc' : {
								desc:'Discussed the importance of nutrition, hydration, mobility, position changes, pressure redistribution, and relief?',
								id:'importanceOfNutritionEtc',
								numbers:false
							},
							'treatmentPlan' : {
								desc:'Explained the treatment plan?',
								id:'treatmentPlan',
								numbers:false
							},
							'preventativeSkinCare' : {
								desc:'Explained preventative skin care?',
								id:'preventativeSkinCare',
								numbers:false
							},
							'ulcerManagement' : {
								desc:'Explained ulcer management (if necessary)?',
								id:'ulcerManagement',
								numbers:false
							},
							'printedEducationMaterial' : {
								desc:'Provided printed education material?',
								id:'printedEducationMaterial',
								numbers:false
							},
							'roleOfVeteran' : {
								desc:'Discussed the role of the Veteran and/or caregivers including active participation in prevention and discharge planning?',
								id:'roleOfVeteran',
								numbers:false
							},
							'responseToEducation' : {
								desc:'Documented response to education:',
								id:'responseToEducation',
								numbers:true
							}


						}
					};
					return ret;
				},
				templateHelpers: function () {
					return this.formData();
				}
			});
	});